/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps.systeminstructions;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWGeneralTab
extends JPanel
implements IVWPropertyTab,
DocumentListener,
IVWPropertyChangeSource {
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWMapNode m_selectedMapNode = null;
    protected Vector m_changedItems = null;
    protected JTextField m_nameTextField = null;
    protected JPanel m_childPanel = null;

    public VWGeneralTab(JPanel childPanel) {
        this.m_childPanel = childPanel;
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        this.m_authPropertyData = authPropertyData;
        this.m_selectedMapNode = vwMapNode;
        this.createControls();
        this.setSelectedStep(vwMapNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedStep(VWMapNode vwMapNode) {
        try {
            this.m_selectedMapNode = vwMapNode;
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField.setText("");
            if (this.m_selectedMapNode != null) {
                this.m_nameTextField.setText(this.getDisplayName());
            }
            this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_nameTextField.getDocument().addDocumentListener(this);
        }
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField = null;
        }
        this.m_childPanel = null;
        this.m_authPropertyData = null;
        this.m_selectedMapNode = null;
        this.removeAll();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected String getDisplayName() {
        if (this.m_selectedMapNode != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_selectedMapNode);
        }
        return null;
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 3, 10);
            this.add((Component)this.getNamePanel(), gbCons);
            if (this.m_childPanel != null) {
                ++gbCons.gridy;
                gbCons.fill = 1;
                gbCons.weighty = 1.0;
                gbCons.insets = new Insets(0, 5, 3, 10);
                this.add((Component)this.m_childPanel, gbCons);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getNamePanel() {
        try {
            VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWResource.s_stepNameStr);
            JPanel childPanel = stepNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_nameTextField, "First");
            return stepNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleDocumentEvent(DocumentEvent event) {
        if (this.m_selectedMapNode == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        }
    }

    private void updateName() {
        try {
            if (this.m_selectedMapNode != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_selectedMapNode);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_selectedMapNode.getName() == null) {
                    return;
                }
                this.m_selectedMapNode.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_selectedMapNode);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

